﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

//GameController is a singleton class used to pass data between scenes and the Game scene
public class GameController : MonoBehaviour
{
    //Our RNG selected procedural values 
    public LSystem LSystem;
    public int CitySeed;
    public Vector2Int PerlinOffset;
    public int CityDensity;
    public int SkyscrapersZoneSizePercentage;
    public int CommercialZoneSizePercentage;

    //Commonly used prefabs for easy access
    public GameObject CarPrefab;
    public GameObject GarageBuildingPrefab;
    public GameObject DecorativeBuildingPrefab;
    public GameObject MinimapIconPrefab;

    //Singleton
    private static GameController _Instance;

    public static GameController Instance
    {
        get
        {
            if (_Instance == null)
            {
                _Instance = FindObjectOfType<GameController>();
            }

            return _Instance;
        }
    }

    private void Start()
    {
        SkyscrapersZoneSizePercentage = 15;
        CommercialZoneSizePercentage = 5;
    }
}
